#%% Inicializace
from datetime import datetime

answer = 42
subject = 'the question'


#%% Starý způsob - operátor %:
print('The Answer is %d! But what is %s?' % (answer, subject))


#%% Novější způsob - str.format:
print('The answer is {0}! But what is {1}?'.format(answer, subject))


#%% Nejnovější způsob - formatted string literal:
print(f'The answer is {answer}! But what is {subject}?')


#%% Escape složených závorek:
print(f'The answer is {answer} {{ more details required }}')


#%% Víceřádkové řetězce:
print(f'''
The answer is obvious: {answer}.
But what was {subject} again?
''')


#%% Mixování formátovaných a neformátovaných řetězců:
print()


#%% Specifikace formátu - https://docs.python.org/3/library/string.html#formatspec
print(f'Precise answer: {answer:20.2e}')


#%% Formátování data:
print(f'The precise date and time is: {datetime.now():%Y-%m-%d %H:%M:%S.%f}')


#%% Vlastní metoda __str__:
class Person:
    def __init__(self, first_name: str, last_name: str):
        self.first_name = first_name
        self.last_name = last_name

    def __str__(self):
        return f'{self.first_name} {self.last_name}'


speaker = Person('Jan', 'Smitka')
print(f'The person currently talking is: {speaker}')


#%% Vlastní formátování - metoda __format__:
class PersonWithFmt:
    def __init__(self, first_name: str, last_name: str):
        self.first_name = first_name
        self.last_name = last_name

    def __str__(self):
        return f'{self.first_name} {self.last_name} (__str__)'

    def __format__(self, format_spec):
        if format_spec == 'rev':
            return f'{self.last_name}, {self.first_name}'
        elif format_spec == 'upper':
            return f'{self.first_name} {self.last_name.upper()}'
        else:
            return f'{self.first_name} {self.last_name} (format_spec={repr(format_spec)})'


speaker_f = PersonWithFmt('Jan', 'Smitka')
print(f'This code is brought to you by: {speaker_f}')
print(f'This code is brought to you by: {speaker_f:}')
print(f'This code is brought to you by: {speaker_f:rev}')
print(f'This code is brought to you by: {speaker_f:upper}')
