from typing import Dict, Any, IO

from p04_testing.example.cluster import Cluster
from urllib.request import urlopen
import json


class ClusterAdapter:
    def __init__(self, api_endpoint: str):
        self.api_endpoint = api_endpoint

    def get(self):
        cluster_data = self._do_get(self.api_endpoint)
        return Cluster.create_from_dict(cluster_data)

    def _do_get(self, url) -> Dict[str, Any]:
        with self._download_cluster_info(url) as response:
            return json.load(response)

    def _download_cluster_info(self, url) -> IO:
        return urlopen(url)
