from decimal import Decimal
from typing import Dict, List


#
# Kontrola z příkazové řádky:
#   mypy 02_type_hinting.py
#


#
# Definice typů pro argumenty a návratovou hodnotu.
#
def get_order_ready_sms_text(greeting: str, order_no: int, price: Decimal) -> str:
    return f'Dear {greeting}, your order #{order_no} is ready! Bring £{price} in unmarked bills.'


# Pozor na to, že mypy nekontroluje funkce, které nemají žádné anotace!
def example_sms():
    print(get_order_ready_sms_text('Arthur Dent', 42, Decimal('14.99')))


#
# Vlastní třídy a složené typy.
#

class TextMessage:
    def __init__(self, phone_num: str, text: str):
        self.phone_num = phone_num
        self.text = text


def send_sms(message: TextMessage):
    pass


def bulk_send_sms(messages: List[TextMessage]):
    pass


def get_sent_messages_by_order_id() -> Dict[int, List[TextMessage]]:
    pass


#
# Cyklické závislosti.
#

class Order:
    def copy_order(self) -> 'Order':
        pass

    def add_item(self, item: 'OrderItem'):
        pass


class OrderItem:
    def get_order(self) -> Order:
        pass


#
# Typy proměnných (novinka v Python 3.6).
#

def get_billing_address(customer_id):
    return eval('str(customer_id)', {'customer_id': customer_id})


def example_func():
    address = get_billing_address(42)
    print(address)


class GlobalBillingInfo:
    address: str


def example_global():
    print(GlobalBillingInfo.address)


#
# Řešení cyklických závislostí v rámci souborů.
#
# noinspection PyUnresolvedReferences
def example_load_models():
    # from p02_new_features.models.order import Order
    pass


def main() -> None:
    example_sms()
    example_load_models()


if __name__ == '__main__':
    main()

