from django.contrib.auth.models import AbstractUser
from django.core.exceptions import PermissionDenied
from django.http import HttpRequest, HttpResponse


def require_superuser(view_func):
    def wrapper(request: HttpRequest, *args, **kwargs):
        user: AbstractUser = request.user
        if user.is_authenticated and user.is_superuser:
            return view_func(request, *args, **kwargs)
        else:
            # Raise exception, redirect to login, ...
            # Whatever fits your app.
            raise PermissionDenied()

    return wrapper



@require_superuser
def admin_view(reqest: HttpRequest):
    return HttpResponse('...')
