from xml.etree import ElementTree
import os
import pandas


def load_xml(file_name) -> ElementTree:
    return ElementTree.parse(file_name)


def generate_data(xml: ElementTree):
    for element in xml.getroot().iter('record'):  # type: ElementTree.Element
        iso_code_el: ElementTree.Element = element.find('code-3166-1-alpha-2')
        if iso_code_el is None:
            continue

        label_element: ElementTree.Element = element.find('./label/lg.version[@lg="ces"]')
        if label_element is None:
            label_element: ElementTree.Element = element.find('./name/original.name/lg.version')

        yield {
            'iso_alpha_2': iso_code_el.text,
            'label': label_element.text if label_element is not None else ''
        }


def main():
    xml_file = os.path.join(os.path.dirname(__file__), 'countries.xml')
    xml = load_xml(xml_file)
    data_frame = pandas.DataFrame(data=generate_data(xml))
    print(data_frame)


if __name__ == '__main__':
    main()
